package kz.dogovor24.module;

import java.util.Hashtable;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

import kz.dogovor24.module.common.BundleLog;
import kz.dogovor24.module.common.BundleProvider;
import kz.dogovor24.module.services.ModuleServiceImpl;
import kz.gov.pki.osgi.layer.api.ModuleService;

public class D24Activator implements BundleActivator {

	@Override
	public void start(BundleContext context) throws Exception {
		ModuleServiceImpl service = new ModuleServiceImpl();
		BundleLog.LOG.discoverLogService();
		BundleProvider.KALKAN.discoverProviderService();
		BundleLog.LOG.info(service + " getting started.");
		registerService(context, service);
	}

	@Override
	public void stop(BundleContext bundleContext) throws Exception {
	}

	private void registerService(BundleContext context, ModuleServiceImpl service) {
		Hashtable<String, String> props = new Hashtable<>();
		props.put("module", "kz.dogovor24.module");
		ServiceRegistration serviceRegistration = context.registerService(ModuleService.class.getName(), service,
				props);
	}
}
