package kz.dogovor24.module.common;
import java.security.Provider;

import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

import kz.gov.pki.osgi.layer.api.NCALayerService;

public enum BundleProvider {

	 KALKAN;

	private static final BundleContext CONTEXT = FrameworkUtil.getBundle(BundleProvider.class).getBundleContext();
    private NCALayerService ncaLayerService;
    private Provider provider;

    public void discoverProviderService() throws InvalidSyntaxException {
        String serviceFilter = "(objectClass=" + NCALayerService.class.getName() + ")";
        ServiceTracker<NCALayerService, NCALayerService> serviceTracker =
                new ServiceTracker(CONTEXT, CONTEXT.createFilter(serviceFilter), null);
        serviceTracker.open();
        ncaLayerService = serviceTracker.getService();
        if (ncaLayerService == null) {
            CONTEXT.addServiceListener((e) -> {
                if (e.getType() == ServiceEvent.REGISTERED) {
                    ncaLayerService = serviceTracker.getService((ServiceReference<NCALayerService>) e.getServiceReference());
                    provider = ncaLayerService.getProvider();
                }
            }, serviceFilter);
        } else {
            provider = ncaLayerService.getProvider();
        }
    }

    public Provider getProvider(){
        return ncaLayerService.getProvider();
    }

}
