package kz.dogovor24.module.form;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.concurrent.CountDownLatch;
import java.util.prefs.Preferences;

import org.json.JSONObject;

import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import kz.dogovor24.module.model.FileExtension;
import kz.dogovor24.module.model.StorageInfo;


public class Form1 {

	CheckBox savePath;
	public String EsedoJson = "";
	JSONObject json;
	public CountDownLatch donelatch;

	public  void createDialog(StorageInfo storageinfo) {
		final Stage stage = new Stage();
		final VBox vbox = this.buildStage(stage );
	    final GridPane gridPane = this.createFormPane();
	    this.addUIControls(storageinfo,gridPane, stage);
	    vbox.getChildren().addAll(new Node[] { gridPane });
	    stage.showAndWait();
	}

	private VBox buildStage(final Stage stage) {
	        stage.setAlwaysOnTop(true);

	        Image iconImage = new Image(getClass().getResourceAsStream("/favicon.png"));
	        stage.getIcons().add(iconImage);

	        stage.setTitle("Dogovor24");

	        final VBox vbox = new VBox();
	        vbox.setSpacing(2.0);
	        vbox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));

	        final Group root = new Group();
	        final BorderPane borderPane = new BorderPane();
	        BorderPane.setMargin(vbox, new Insets(5.0, 5.0, 5.0, 5.0));
	        borderPane.setCenter(vbox);

	        final Scene scene = new Scene(root, 400.0, 160.0);
	        scene.setRoot(borderPane);
	        stage.setScene(scene);
	        stage.setResizable(false);
	        stage.centerOnScreen();
	       

	        return vbox;
	    }

	private GridPane createFormPane() {
	        final GridPane gridPane = new GridPane();
	        gridPane.setAlignment(Pos.CENTER);
	        gridPane.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
	        gridPane.setHgap(10.0);
	        gridPane.setVgap(10.0);
	        final ColumnConstraints columnOneConstraints = new ColumnConstraints(1.0, 1.0, Double.MAX_VALUE);
	        columnOneConstraints.setHalignment(HPos.RIGHT);
	        final ColumnConstraints columnTwoConstrains = new ColumnConstraints(200.0, 200.0, Double.MAX_VALUE);
	        columnTwoConstrains.setHgrow(Priority.ALWAYS);

	        gridPane.getColumnConstraints().addAll(new ColumnConstraints[] {columnOneConstraints, columnTwoConstrains });
	        return gridPane;
	    }

    private void addUIControls(StorageInfo storageinfo,final GridPane gridPane, final Stage stage) {
		    savePath = new CheckBox("Запомнить путь к сертификату");
	        savePath.setDisable(true);
	        final Label subHeaderLabel = new Label("Выберите сертификат для подписи");

	        subHeaderLabel.setFont(Font.font("Arial", FontWeight.BLACK, 12.0));
	        gridPane.add(subHeaderLabel, 1, 1);
	        GridPane.setHalignment(subHeaderLabel, HPos.LEFT);


	        final TextField containerField = new TextField();
	        containerField.setPromptText("Укажите путь к файлу");
	        containerField.setDisable(true);
			String path =LoadFromRegistry();
			containerField.setText(path);
			savePath.setOnAction(event -> SaveToRegistry(containerField.getText()));
	        final Button fileBtn = new Button("Выбрать...");
	        fileBtn.setOnAction(e -> {
	            final File f = this.getFile("", FileExtension.pkcs12, stage);
	            if (f != null) {
	                containerField.setText(f.getPath());
	                savePath.setDisable(false);
	               SaveToRegistry(f.getPath());

	            }
	        });
	        final HBox hb = new HBox();
	        hb.setSpacing(1.0);
	        hb.getChildren().addAll(new Node[] { containerField, fileBtn });
	        HBox.setHgrow(containerField, Priority.ALWAYS);
	        gridPane.add(hb, 1, 2);

	        final PasswordField passwordField = new PasswordField();
	        gridPane.add(passwordField, 1, 3);
	        passwordField.setPromptText("Введите пароль");
	        final Button submitButton = new Button("Подписать");


	        submitButton.setDefaultButton(true);
	        submitButton.setPrefWidth(100.0);
	        submitButton.setOnAction(e-> {

	        	if (containerField.getText() == null || containerField.getText().isEmpty() || passwordField.getText()== null || passwordField.getText().isEmpty()) {
	                showAlert(Alert.AlertType.ERROR, stage, "Внимание ","Необходимо указать сертификат и пароль");
	                return;
	              }
	        	submitButton.setDisable(true);
	        	storageinfo.setContainer( containerField.getText() );
	        	storageinfo.setPassword ( passwordField.getText() );
	            stage.close();

	        });
	        gridPane.add(savePath,  1, 4);
	        gridPane.add(submitButton, 1, 4);
	        GridPane.setHalignment(submitButton, HPos.LEFT);

	        GridPane.setHalignment(passwordField, HPos.LEFT);
	        GridPane.setHalignment(containerField, HPos.LEFT);

	        GridPane.setHalignment(savePath, HPos.RIGHT);
	            stage.close();
	    }


    private File getFile(final String initialFilePath, final FileExtension fileExtension, final Stage stage) {
	        final FileChooser fileChooser = new FileChooser();
	        if (fileExtension != null && !fileExtension.equals(FileExtension.all)) {
	            final FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(fileExtension.getDesc(), fileExtension.getExts());
	            fileChooser.getExtensionFilters().add(extFilter);
	        }
	        if (initialFilePath != null && !initialFilePath.trim().isEmpty()) {
	            final File initialDir = new File(initialFilePath);
	            if (Files.exists(initialDir.toPath(), new LinkOption[0])) {
	                fileChooser.setInitialDirectory(initialDir);
	            }
	        }
	        fileChooser.setTitle("\u0412\u044b\u0431\u0440\u0430\u0442\u044c...");
	        return fileChooser.showOpenDialog(stage);
	  }

    public void showAlert(Alert.AlertType alertType, Window owner, String title, String message) {
        Alert alert = new Alert(alertType);
        alert.setTitle(title);
        alert.setHeaderText((String)null);
        alert.setContentText(message);
        alert.initOwner(owner);
        alert.show();
      }

	private String LoadFromRegistry() {
			String PREF_KEY = "D24ModulePath";
			Preferences userPref = Preferences.userRoot();
			String p = userPref.get(PREF_KEY, PREF_KEY);
			if (p != "") {
				savePath.setSelected(true);
			}
			return p;
		}

	private void SaveToRegistry(String filepath) {
		if (savePath.isSelected()) {
			String PREF_KEY = "D24ModulePath";
			Preferences userPref = Preferences.userRoot();
			userPref.put(PREF_KEY, filepath);
		}

		// KEY:D24ModulePath
		// VALUE:Software\\Microsoft\\Windows\\CurrentVersion\\Run
	}

}
