package kz.dogovor24.module.model;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;



public class SigningEntity {

	private final PrivateKey key;
	private final List<X509Certificate> certificateChain;

	public SigningEntity(PrivateKey key, List<X509Certificate> certificateChain) {
		this.key = key;
		this.certificateChain = certificateChain;
	}

	public PrivateKey getKey() {
		return this.key;
	}

	public List<X509Certificate> getCertificateChain() {
		return this.certificateChain;
	}


	@Override
	public boolean equals(Object o) {
		if (o == this) {
			return true;
		} else if (!(o instanceof SigningEntity)) {
			return false;
		} else {
			SigningEntity other = (SigningEntity) o;
			Object this$key = this.getKey();
			Object other$key = other.getKey();
			if (this$key == null) {
				if (other$key != null) {
					return false;
				}
			} else if (!this$key.equals(other$key)) {
				return false;
			}

			Object this$certificateChain = this.getCertificateChain();
			Object other$certificateChain = other.getCertificateChain();
			if (this$certificateChain == null) {
				if (other$certificateChain != null) {
					return false;
				}
			} else if (!this$certificateChain.equals(other$certificateChain)) {
				return false;
			}

			return true;
		}
	}

	@Override
	public int hashCode() {
		boolean PRIME = true;
		int result = 1;
		Object $key = this.getKey();
		result = result * 59 + ($key == null ? 43 : $key.hashCode());
		Object $certificateChain = this.getCertificateChain();
		result = result * 59 + ($certificateChain == null ? 43 : $certificateChain.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "SigningEntity(key=" + this.getKey() + ", certificateChain=" + this.getCertificateChain() + ")";
	}

}
