package kz.dogovor24.module.services;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

import javax.security.auth.x500.X500Principal;

import org.json.JSONArray;
import org.json.JSONObject;

import kz.dogovor24.module.common.BundleLog;
import kz.dogovor24.module.common.BundleProvider;
import kz.dogovor24.module.model.StorageInfo;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.ocsp.CertificateID;
import kz.gov.pki.kalkan.ocsp.OCSPReq;
import kz.gov.pki.kalkan.ocsp.OCSPReqGenerator;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.CMSUtil;
import kz.gov.pki.provider.utils.PKIXUtil;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;
import kz.gov.pki.reference.TSAPolicy;

public class CmsWithDataService {

	KeyStore _keyStore = null;
	String _alias = null;
	Map<X500Principal, X509Certificate> _caCertsMap;
	String OCSP_URL;

	public CmsWithDataService() {
		this.OCSP_URL = (System.getProperty("knca.ocspresponderURL") == null) ? "http://ocsp.pki.gov.kz"
				: System.getProperty("knca.ocspresponderURL");
	}

	public String CmsBatchSign(String jsonData, StorageInfo storageinfo) {

		JSONObject jsonObject = new JSONObject(jsonData);
		JSONArray args = jsonObject.getJSONArray("args");

		JSONObject jsonResponseObject = new JSONObject();
		JSONArray jsonResultArray = new JSONArray();

		for (Object o : args) {
			try {
				CMSSignedData cmsdata = signCMS(o.toString(), storageinfo);
				if(cmsdata == null) {
					throw new Exception();
				}
				byte[] encodedResult = cmsdata.getEncoded();
				String encodedData = new String(Base64.getEncoder().encode(encodedResult));
				jsonResultArray.put(encodedData);
			} catch (Exception e) {
				JSONObject result = new JSONObject();
				result.put("code", "500");
				result.put("message", "action canceled");
				String resultString = result.toString();
				return resultString;
			}

		}
		jsonResponseObject.put("code", "200");
		jsonResponseObject.put("responseObject", jsonResultArray);
		String resultString = jsonResponseObject.toString();
		return resultString;
	}

	public String trySignCMS(String jsonString, StorageInfo storageinfo) throws IOException {		
		try {
			JSONObject jsonObject = new JSONObject(jsonString);
			JSONArray jsonArray = new JSONArray();
			jsonArray = jsonObject.getJSONArray("args");
			String b64doc = jsonArray.getString(0);
			CMSSignedData cmsSignedData = signCMS(b64doc, storageinfo);
			if(cmsSignedData == null) {
				throw new Exception();
			}
			byte[] encodedResult = cmsSignedData.getEncoded();
			String encodedData = new String(Base64.getEncoder().encode(encodedResult));
			JSONObject result = new JSONObject();
			result.put("code", "200");
			result.put("responseObject", encodedData);
			String resultString = result.toString();
			return resultString;
		}
		catch(Exception e) {
			JSONObject result = new JSONObject();
			result.put("code", "500");
			result.put("message", e.getMessage());
			String resultString = result.toString();
			return resultString;
		}
						
	}

	public CMSSignedData signCMS(String b64data, StorageInfo storageInfo) throws Exception {
		byte[] filebytes = Base64.getDecoder().decode(b64data);
		String pwrd = storageInfo.getPassword();
		try {

			InputStream inputStream = new FileInputStream(storageInfo.getContainer());
			this._keyStore = KeyStore.getInstance("PKCS12", BundleProvider.KALKAN.getProvider().getName());
			this._keyStore.load(inputStream, storageInfo.getPassword().toCharArray());
			Enumeration<String> als = this._keyStore.aliases();
			
			while (als.hasMoreElements()) {
				this._alias = als.nextElement();
			}
			X509Certificate cert = (X509Certificate) this._keyStore.getCertificate(this._alias);
			if(cert == null) {
				throw new Exception("Неверный пароль");
			}
			List<String> keyusage = cert.getExtendedKeyUsage();
			if (keyusage.contains("1.3.6.1.5.5.7.3.2")) {
				throw new Exception("Необходимо использовать ключ для подписи!");
			}
			byte[] ocspResponse = getOcspTicket(cert);
			//String ocspstr = new String(Base64.getEncoder().encode(ocspResponse));
			SigningEntity signingEntity = getSigningEntity(_keyStore, _alias, pwrd.toCharArray());
			CMSSignedData cmsSignedData = CMSUtil.createCAdES(signingEntity, filebytes, true, BundleProvider.KALKAN.getProvider());
			TSAProfile tsaProfile = new TSAProfile();
			tsaProfile.setHashAlgorithm(KalkanHashAlgorithm.HASH_SHA256);
			tsaProfile.setRequestMethod(KNCAServiceRequestMethod.GET);
			tsaProfile.setTsaPolicy(TSAPolicy.TSA_RSA);
		cmsSignedData = CMSUtil.applyCAdEST(cmsSignedData, signingEntity, tsaProfile, BundleProvider.KALKAN.getProvider());
			//byte[] encodedResult = cmsSignedData.getEncoded();
			//String encodedData = new String(Base64.getEncoder().encode(encodedResult));
			return cmsSignedData;
		} catch (Exception ex) {
			throw new Exception(ex.getMessage());
		}
	}

	private byte[] getOcspTicket(X509Certificate certificate) {
		byte[] ocspTicketArray;
		try {
			HttpURLConnection con;
			X509Certificate caCert = this._caCertsMap.get(certificate.getIssuerX500Principal());
			byte[] ocspReq = getOcspPackage(certificate.getSerialNumber(), caCert, CertificateID.HASH_SHA256);
			String b64Req = new String(Base64.getEncoder().encodeToString(ocspReq));
			String getUrl = this.OCSP_URL + "/" + b64Req;
			if (getUrl.length() <= 2) {
				URL url = new URL(getUrl);
				con = (HttpURLConnection) url.openConnection();
			} else {
				URL url = new URL(this.OCSP_URL);
				con = (HttpURLConnection) url.openConnection();
				con.setDoOutput(true);
				con.setRequestMethod("POST");
				con.setRequestProperty("Content-Type", "application/ocsp-request");
				OutputStream os = con.getOutputStream();
				os.write(ocspReq);
				os.close();
			}
			InputStream inputStream = con.getInputStream();
			OCSPResp response = new OCSPResp(inputStream);
			ocspTicketArray = response.getEncoded();
			con.disconnect();
		} catch (Exception e) {
			ocspTicketArray = null;
		}
		return ocspTicketArray;
	}

	private byte[] getOcspPackage(BigInteger serialNr, Certificate cacert, String hashAlg) throws Exception {
		OCSPReqGenerator gen = new OCSPReqGenerator();
		CertificateID certId = new CertificateID(hashAlg, (X509Certificate) cacert, serialNr, "KALKAN");
		gen.addRequest(certId);
		OCSPReq req = gen.generate();
		return req.getEncoded();
	}


	  public static SigningEntity getSigningEntityChained(KeyStore keyStore, String alias, char[] password, List<X509Certificate> caCerts) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, ProviderUtilException {
	      PrivateKey key = (PrivateKey)keyStore.getKey(alias, password);
	      X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
	      Object certChain;
	      if (caCerts != null) {
	         PKIXUtil pkixUtil = (new PKIXUtil(cert, caCerts)).allowExpired();
	         pkixUtil.validate();
	         certChain = pkixUtil.getCertificateChain();
	      } else {
	         certChain = new ArrayList();
	         ((List)certChain).add(cert);
	      }

	      return new SigningEntity(key, (List)certChain);
	   }

	   public static SigningEntity getSigningEntity(KeyStore keyStore, String alias, char[] password) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, ProviderUtilException {
	      return getSigningEntityChained(keyStore, alias, password, (List)null);
	   }



}
