package kz.dogovor24.module.services;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;

import org.json.JSONObject;

import javafx.application.Platform;
import kz.dogovor24.module.common.BundleLog;
import kz.dogovor24.module.form.Form1;
import kz.dogovor24.module.model.StorageInfo;
import kz.gov.pki.osgi.layer.api.ModuleService;

public class ModuleServiceImpl implements ModuleService {

	private static final String SIGN_CMS = "signCMS";
	private static final String BATCH_SIGN_CMS = "batchSignCMS";
	private static final String SIGN_ESEDO = "signEsedo";

	@Override
	public String process(String jsonString, String jsonAddInfo) {
		JSONObject jsonObj = new JSONObject(jsonString);
	     String jsonMethod = jsonObj.optString("method");

	     StorageInfo storageInfo = new StorageInfo();
			Form1 certificateChooser = new Form1();
			CountDownLatch doneLatch = new CountDownLatch(1);
			initAndShowGUI(certificateChooser, storageInfo, doneLatch);
			try {
				doneLatch.await();
			} catch (InterruptedException var23) {
				JSONObject result = new JSONObject();
			    result.put("code", "500");
			    result.put("message",var23.getMessage());
			    String resultString = result.toString();
				return resultString;
			}


	     if(jsonMethod.equals(SIGN_CMS)) {

	    	 try {
	    		 CmsWithDataService service = new CmsWithDataService();
				String result =  service.trySignCMS(jsonObj.toString(), storageInfo);
				return result;
			} catch (IOException e) {
				JSONObject result = new JSONObject();
			    result.put("code", "500");
			    result.put("message",e.getMessage());
			    String resultString = result.toString();
				return resultString;
			}
	     }
	     else if(jsonMethod.equals(BATCH_SIGN_CMS)) {
	    	 try {
	    		 CmsWithDataService service = new CmsWithDataService();
	    		 String result = service.CmsBatchSign(jsonObj.toString(), storageInfo);
	    		 return result;
	    	 }
	    	 catch(Exception e) {
	    		 JSONObject result = new JSONObject();
				    result.put("code", "100");
				    result.put("message",e.getMessage());
				    String resultString = result.toString();
					return resultString;
	    	 }
	     }
	     else if(jsonMethod.equals(SIGN_ESEDO)) {
	    	 try {
	    		 EsedoSignService esedoService = new EsedoSignService();
	    		 String result = esedoService.process(jsonString, storageInfo);
	    		 return result;
	    	 }
	    	 catch(Exception e) {
	    		 JSONObject result = new JSONObject();
				    result.put("code", "500");
				    result.put("responseObject",e.getMessage());
				    String resultString = result.toString();
					return resultString;
	    	 }
	     }
		return "error: method not found [" + jsonMethod + "]";

	}
	private static void initAndShowGUI(Form1 certchooser, StorageInfo storageInfo2, CountDownLatch doneLatch) {
		 Platform.runLater(() -> {
	         try {
	            certchooser.createDialog(storageInfo2);
	         }
	         catch(Exception e ) {
	        	 BundleLog.LOG.error("Exception", e);
	         }
	         finally {
	            doneLatch.countDown();
	         }

	      });
	   }

}
